function [allidx,nidx,all_data,ndata] = punc_colo_all(pdata,ori,chan,varargin)
%Synatax:   [class] = punc_colo_all(punc_data,1,[2 4 7],'termi',3,'mod',1,'mod_fltr',1,'pp_fltr',1,'prepost',[0 1 0]);
%Input:     pdata = the original puncta data structure (punc_data) from
%                   punc_locodist. 
%           ori = the channel you want to use as the central pivot
%           chan = channel or channels that you want colocalized with your
%                   ori channel.
%           termi = termi once specificed, kicks the function into uber
%                   classify mode, or elastic distance threshold mode,
%                   essentially create a ori-termi distance filter base
%                   vector
%           mod = 0 or 1.  0 = off (default) 1 = on.  When on the distance
%                   of the punctas are modified by the properties of
%                   punctas.
%           mod_fltr = 0 or 1. 0 = off(default) 1 = on.  When any parameter
%                   of a puncta that puts it 3std away will remove the
%                   puncta from consideration.
%           pp_fltr = 0 or 1.  1 = on 0 = off(default).
%           prepost = a vector the same length as chan.  0 =
%                   near ori, 1i = near termi.  If pp_fltr is on and
%                   this is left blank, all channels will be considered
%                   near ori (0).  Now everything works the same, but
%                   numbers above 0, e.g. 2, 13, now will modify distance
%                   near termi, such that the termi point will be accepted
%                   if the distance to the termi is d.termi-2 or 13 <d.ori.
%                   Numbers below 0, e.g., -2,-13 now modify distance near
%                   ori, i.e., d.ori-2 or 13 <d.termi.  1i is special in
%                   that 1i is actually 0 for termi distances. 100i means
%                   no perferences, can be used for Astrocytes.  Note:
%                   positive numbers bring points together, either ori or
%                   termi, and negative number pushes the points apart.
%           fltr3 = Filter the third colo channel for uniquenss, this is
%                   necessary becaues the third channel can be used
%                   multiple times.  This will only affect our lower bound
%                   nearest calculation, as the upperbound (all) is relaxed
%                   so that the third channel can be used multiple times,
%                   as the upper bound is the maximal possible # of colo
%                   events in the dataset.  Default = 1 (on).  Now if you
%                   enter 2, you will initiate filter to unique on the all
%                   data set.
%           visual = visual check of the data.  Default = 0 (off)
%Output:    allidx = the index locations of the ori points that does not
%                   belong to a ori-termi pair that fits criteria.  when
%                   considering the colocalization of all possible
%                   comibinations of one ori to all the other channels,
%                   this is definitely an upperbount.
%           nidx = the index location of the ori points that does not
%                   colocalize based on picking the shortest points colo
%                   events.  A lower bound.
%           all_data = data structure containing all of the classified
%                   colocalization events.
%           n_data = data structure containing the nearest colocalization
%                   event per origin pivot.

%parse threshold & error check
[mod,mod_fltr,termi,pp_fltr,prepost,fltr3,fltrall,visual,multi] = parse(varargin,chan);

%extract out some important data.
filenames = pdata(1).filenames;
%the ori vertices matching termi with properties and distances
overts = [cell2mat(pdata(ori).all_vert(:,:,termi)) cell2mat(pdata(ori).all_prop(:,:,termi)) cell2mat(pdata(ori).all_dist(:,:,termi))];
tverts = [cell2mat(pdata(ori).all_termi(:,:,termi)) cell2mat(pdata(ori).all_tprop(:,:,termi))];     %the termi vertices with properties

%pull out the full dataset to get some global values
ori_props = overts(:,5:end-1);
termi_props = tverts(:,4:end);
meds_ori = median(ori_props(~isnan(ori_props(:,1)),:));    %median
meds_termi = median(termi_props(~isnan(termi_props(:,1)),:));
outlier_fltr_ori = std(ori_props(~isnan(ori_props(:,1)),:))*3+meds_ori;
outlier_fltr_termi = std(termi_props(~isnan(termi_props(:,1)),:))*3+meds_termi;

%reassign overts
overts = pdata(ori).all_vert(:,:,termi);
tverts = pdata(ori).all_termi(:,:,termi);
o_prop = pdata(ori).all_prop(:,:,termi);        %ori properties
t_prop = pdata(ori).all_tprop(:,:,termi);       %termi properties
colo_dist = pdata(ori).all_dist(:,:,termi);     %colocalization distance
idx = [];    %initiate the total index of removal for the cell array

if multi && isempty(gcp('nocreate'))   %multi is on and the pool is not already on
    parpool  %parallelize
    pool_on = 1;  %I did it.
else
    pool_on = 0;
end

%step through the number of channels.
for i = 1:size(chan,2)
    t_overt = cell(size(overts,1),1);   %initiate the total data array: a structure would be more pleasing, but this will work.
    t_tvert = cell(size(overts,1),1);
    t_3vert = cell(size(overts,1),1);
    t_oprop = cell(size(overts,1),1);
    t_tprop = cell(size(overts,1),1);
    t_3prop = cell(size(overts,1),1);
    t_sort_idx = cell(size(overts,1),1);
    n_overt = cell(size(overts,1),1);   %initiate nearest
    n_tvert = cell(size(overts,1),1);
    n_3vert = cell(size(overts,1),1);
    n_oprop = cell(size(overts,1),1);
    n_tprop = cell(size(overts,1),1);
    n_3prop = cell(size(overts,1),1);
    %ok lets work on the colo channels a bit.  We need to figure out the
    %population propties data and distance data.
    %curr_colo_chan = [pdata(ori).all_termi(:,:,chan(i)) cell2mat(pdata(ori).all_tprop(:,:,chan(i)))];   %the colo channel vertices and prop array
    curr_vert = pdata(ori).all_termi(:,:,chan(i));          %current vertices
    curr_prop = pdata(ori).all_tprop(:,:,chan(i));        %current properties
    curr_dist = pdata(ori).all_dist(:,:,chan(i));         %current distances
    %now get the median & std
    curr_prop_tmp = cell2mat(curr_prop);
    curr_prop_tmp(isnan(curr_prop_tmp(:,1)),:) = [];        %remove NaN
    curr_dist_tmp = cell2mat(curr_dist);
    curr_dist_tmp(isnan(curr_dist_tmp(:,1)),:) = [];        %remove NaN
    med_prop = median(curr_prop_tmp);
    med_dist = median(curr_dist_tmp);
    std_prop = std(curr_prop_tmp);
    std_dist = std(curr_dist_tmp);
    
    %now lets go through each pair and determin if it has a colocalization
    %partner in the 3rd channel.
    cell_idx = zeros(size(curr_vert,1),1);  %initiate the index of removal for the cell array
    %h = waitbar(0,['Processing ' filenames{chan(i)}(1:end-4) ' colocalization: 0']);    %initialize progress bar.
    parfor j = 1:size(overts,1)
        %waitbar(j/size(overts,1),h,['Processing ' filenames{chan(i)}(1:end-4) ' colocalization: ' num2str(j)]);   %update progress
        %now grab ori and termi
        curr_termi = tverts{j,1};
        curr_colo_dist = colo_dist{j,1};
        if ~isnan(curr_termi)  %no need to proceed any furthere if there is no axis.
            curr_ori = overts{j,1};
            curr_oprop = o_prop{j,1};
            curr_tprop = t_prop{j,1};
            %grab the third point
            curr_colo = [curr_vert{j,1} curr_prop{j,1} curr_dist{j,1}];  %This is the THIRD point!
            if ~isnan(curr_colo)        %pointless to proceed if there is no third point
                %now filter out some outliers
                [ydist,x] = find(curr_colo(:,end)>std_dist*3+med_dist);
                yprop = curr_colo(:,4:end-1)>repmat(std_prop.*3+med_prop,size(curr_colo,1),1);
                [yprop,x] = find(yprop(sum(yprop,2)>0));
                %create the modification index of the origin and termi
                if mod
                    %generate ori modification index
                    ori_mod_idx = mean(o_prop{j,1}./repmat(meds_ori,size(curr_ori,1),1),2);
                    termi_mod_idx = mean(t_prop{j,1}./repmat(meds_termi,size(curr_termi,1),1),2);
                    %filter ori for outliers
                    if mod_fltr
                        %create the outlier filter array
                        outlier_fltr_o = outlier_fltr_ori;    %3 std away is too far
                        %now filter out the outliers
                        outlier_fltr_o = outlier_fltr_o<=curr_oprop(1,:);
                        outlier_fltr_o = max(outlier_fltr_o);      %create removal index
                        if ~outlier_fltr_o      %if the ori is an outlier game over.
                            %termi's turn
                            outlier_fltr_t = repmat(outlier_fltr_termi,size(curr_termi,1),1);    %3 std away is too far
                            outlier_fltr_t = outlier_fltr_t<=curr_tprop;
                            outlier_fltr_t = max(outlier_fltr_t,[],2);      %create removal index
                            outlier_fltr_t = find(outlier_fltr_t==1);
                            %remove
                            curr_termi(outlier_fltr_t,:) = [];
                            curr_ori(outlier_fltr_t,:) = [];
                            curr_colo_dist(outlier_fltr_t,:) = [];
                            termi_mod_idx(outlier_fltr_t,:) = [];
                            ori_mod_idx(outlier_fltr_t,:) = [];
                            curr_oprop(outlier_fltr_t,:) = [];
                            curr_tprop(outlier_fltr_t,:) = [];
                        end
                    end
                    %now using the ori and termi mod indexs to create the final mod
                    mod_idx = mean([termi_mod_idx ori_mod_idx],2);
                    %modify or weigh the colocalization distances
                    curr_colo_dist = curr_colo_dist.*mod_idx;
                    %OK now set an upper bound on the colo distance
                    %any modifed distance greater than 2.5um is too far so:
                    %curr_colo_dist(curr_colo_dist>25) = 25;     %set to 25
                else
                    outlier_fltr_o = 0; %default no filters
                end
                
                if ~outlier_fltr_o && ~isempty(curr_termi)  %make sure the filter did not remove all the points or the origin
                    %now permute the search in all ways
                    %initiate
                    t_overt_tmp = [];
                    t_tvert_tmp = [];
                    t_oprop_tmp = [];   %distance of 0 is added
                    t_tprop_tmp = [];
                    t_3vert_tmp = [];
                    t_3prop_tmp = [];
                    nearest_tmp = [];
                    t_idx_tmp = [];
                    for k = 1:size(curr_termi,1)
                        %lets filter based on proximity to ori or termi priors
                        if pp_fltr==1  %type 1, recalculate distance based on vertices here
                            pp_comp = curr_colo(:,1:3);  %matching termi (third channel)
                            pp_ori = repmat(curr_ori(1,1:3),size(curr_colo,1),1);  %get the ori vertices & match in size
                            pp_termi = repmat(curr_termi(k,:),size(curr_colo,1),1); %get the actual terminal vertices.
                            %now calculate distances and determine elegibility of the
                            %vertex
                            switch prepost(1,i)
                                case 0      %closer to ori
                                    ypp = dddist(pp_ori,pp_comp)>dddist(pp_termi,pp_comp);
                                case 1i      %closer to termi
                                    ypp = dddist(pp_ori,pp_comp)<dddist(pp_termi,pp_comp);
                                case 100i     %ignostic
                                    ypp = [];  %do not filter anything
                                otherwise       %modify by prepost number
                                    if prepost(1,i)<=0       %closer to ori
                                        ypp = dddist(pp_ori,pp_comp)>dddist(pp_termi,pp_comp)/abs(prepost(1,i));  %ori must be closer than termi
                                    else                    %closer to termi
                                        ypp = dddist(pp_ori,pp_comp)/abs(prepost(1,i))<dddist(pp_termi,pp_comp);  %ori must be further than termi
                                    end
                            end
                        else
                            ypp = [];           %index not used.
                        end
                        %find which one actually is within distance
                        y = repmat(curr_colo_dist(k,1),size(curr_colo,1),1)<curr_colo(:,end);   %compare this permutation
                        if visual
                            vcheck(pp_ori,pp_termi,pp_comp,or(ypp,y),prepost(1,i),curr_colo_dist(k,1));
                            keyboard
                            close all
                        end
                        ypp = find(ypp==1);     %create actual index
                        y = find(y==1);
                        y = unique(vertcat(y,ypp,ydist,yprop));        %remove all unmatch or unqualified data points
                        curr_colo_tmp = curr_colo;     %lets not mess the the original
                        curr_colo_tmp(y,:) = [];        %get gone
                        %we are going to output two datasets, one is all possible
                        %colocalizations, which is for sure an overcount, and one is
                        %the nearest possible one, which is the floor, but we are not
                        %necessarily picking the correct colocalization event.
                        %all points - upper bound
                        if ~isempty(curr_colo_tmp)&&~isnan(curr_colo_dist(k,1))   %there is a match
                            t_overt_tmp = vertcat(t_overt_tmp,repmat(curr_ori(1,1:4),size(curr_colo_tmp,1),1));
                            t_tvert_tmp = vertcat(t_tvert_tmp,repmat([k curr_termi(k,1:3)],size(curr_colo_tmp,1),1));   %k is added as an ordinal, remove later
                            t_oprop_tmp = vertcat(t_oprop_tmp,horzcat(repmat(curr_oprop(1,1:end),size(curr_colo_tmp,1),1),zeros(size(curr_colo_tmp,1),1)));   %distance of 0 is added
                            t_tprop_tmp = vertcat(t_tprop_tmp,horzcat(repmat(curr_tprop(k,1:end),size(curr_colo_tmp,1),1),repmat(colo_dist{j,1}(k,1),size(curr_colo_tmp,1),1)));
                            t_3vert_tmp = vertcat(t_3vert_tmp,curr_colo_tmp(:,1:3));
                            t_3prop_tmp = vertcat(t_3prop_tmp,curr_colo_tmp(:,4:end));
                            t_idx_tmp = vertcat(t_idx_tmp,k);
                            %nearest points - lower bound
                            nidx = find(curr_colo_tmp(:,end)==min(curr_colo_tmp(:,end)));
                            nearest_tmp = vertcat(nearest_tmp,[repmat(k,size(nidx,1),1)...
                                curr_colo_tmp(nidx,1:end) curr_colo_tmp(nidx,end)+curr_colo_dist(k,1)]);     %k will be used later to pick out the overt and tvert
                            %the distances are summed as to not actually weigh the
                            %distances.
                        else    %there is no match
                            t_idx_tmp = vertcat(t_idx_tmp,nan);
                        end
                    end
                    %now find the nearest overall
                    if ~isempty(nearest_tmp)
                        %all
                        t_overt{j,1} = t_overt_tmp;
                        t_tvert{j,1} = t_tvert_tmp;
                        t_oprop{j,1} = t_oprop_tmp;   %distance of 0 is added
                        t_tprop{j,1} = t_tprop_tmp;
                        t_3vert{j,1} = t_3vert_tmp;
                        t_3prop{j,1} = t_3prop_tmp;
                        t_sort_idx{j,1} = t_idx_tmp;
                        %nearest
                        nidx = find(nearest_tmp(:,end)==min(nearest_tmp(:,end)));
                        nearest_tmp = nearest_tmp(nidx,:);
                        %Ok lets talk a little about contingencies.  I
                        %actually wrote this so it will work, but there is
                        %the smallest of chances that out of all of this
                        %calculation there are two nearest points, in this
                        %case, as you see below, we use the very scientific
                        %pick the first principle.  This isn't completely
                        %evil, because 1) this is really rare, if not then
                        %we got to reconsider this, the other is that it is
                        %what the other all data analysis is all about in
                        %that case both of these points will be kept.
                        n_overt{j,1} = curr_ori(1,1:4);
                        n_tvert{j,1} = curr_termi(nearest_tmp(1,1),1:3);
                        n_oprop{j,1} = [curr_oprop(1,1:end) 0];     %add 0 for distance
                        n_tprop{j,1} = [curr_tprop(nearest_tmp(1,1),1:end) colo_dist{j,1}(nearest_tmp(1,1),1)];    %properties plus distance    
                        n_3vert{j,1} = nearest_tmp(1,2:4);
                        n_3prop{j,1} = nearest_tmp(1,5:end-1);      %get rid of the last number, which is a modified distance
                        n_sort_idx(j,1) = nearest_tmp(1,1);
                    else    %no match
                        cell_idx(j,1) = 1;
                        n_sort_idx(j,1) = 0;
                    end
                else    %fall through no axis, because of filtering
                    cell_idx(j,1) = 1;
                    n_sort_idx(j,1) = 0;
                end
            else %fall through no third point
                 cell_idx(j,1) = 1;
                 n_sort_idx(j,1) = 0;
            end
        else %fall through no axis, second point
            cell_idx(j,1) = 1;
            n_sort_idx(j,1) = 0;
        end
    end
    cell_idx = find(cell_idx==1);   %create actual index
    %store the arrays
    idx = vertcat(idx,cell_idx);
    %close(h);   %close progress bar
    %now create data structure
    all_data(i).name = filenames{chan(i)};  %third point data set
    all_data(i).vert = t_overt;
    all_data(i).oprop = t_oprop;
    all_data(i).termi = t_tvert;
    all_data(i).tprop = t_tprop;
    all_data(i).third = t_3vert;
    all_data(i).thirdprop = t_3prop;
    all_data(i).sort_idx = t_sort_idx;
    ndata(i).name = filenames{chan(i)};  %third point data set
    ndata(i).vert = n_overt;
    ndata(i).oprop = n_oprop;
    ndata(i).termi = n_tvert;
    ndata(i).tprop = n_tprop;
    ndata(i).third = n_3vert;
    ndata(i).thirdprop = n_3prop;
    ndata(i).sort_idx = n_sort_idx;
end

if multi && pool_on
    delete(gcp('nocreate'))
end

idx = unique(idx);  %the oris that does not colo

%now create the master list, the one where colocalization for all channels
%are considered
%fist deal the nearest point case, because it's simpler.
if size(chan,2)>1   %only need to do this is we are colocalization accross more than three channels
    for l = 1:size(chan,2)
        idx_array(:,l) = ndata(l).sort_idx;   %put all the indexes together
    end
    fidx = mean(idx_array,2);           %if all channels uses the same axis, then the mean is not a fraction.
    fidx = fidx==idx_array(:,1);
    fidx = find(fidx==0);   %generate the final index that removes not matched axes
    nidx = unique(vertcat(idx,fidx));   %this is the almost master index when considering nearest point
    aord_idx = linspace(1,size(all_data(l).third,1),size(all_data(l).third,1))';  %this ordinal index will be used for the final distillation of the all set
    aord_idx(idx,:) = [];
    
    %store the nearest data
    for l = 1:size(chan,2)
        ndata(l).vert(nidx,:) = [];     %wittle down to the final
        ndata(l).oprop(nidx,:) = [];
        ndata(l).termi(nidx,:) = [];
        ndata(l).tprop(nidx,:) = [];
        ndata(l).third(nidx,:) = [];
        ndata(l).thirdprop(nidx,:) = [];
        %instead of doing this "if ~max(idx==m)" lets just remove the non
        %colo events first. for allidx processing down below
        all_data(l).vert(idx,:) = [];     %remove the non-events
        all_data(l).oprop(idx,:) = [];
        all_data(l).termi(idx,:) = [];
        all_data(l).tprop(idx,:) = [];
        all_data(l).third(idx,:) = [];
        all_data(l).thirdprop(idx,:) = [];
        all_data(l).sort_idx(idx,:) = [];
    end
    
    %Now move on to the all data side
    allidx = [];   %starting off point
    h2 = waitbar(0,['Generating colocalizaing matrix for all channels: 0']);    %initialize progress bar.
    for m = 1:size(all_data(1).vert,1)
        waitbar(m/size(all_data(1).vert,1),h2,['Generating colocalization matrix for all channels: ' num2str(m)]);   %update progress
        idx_array = [];
        fidx = [];  
        for n = 1:size(chan,2)
            idx_array(:,n) = all_data(n).sort_idx{m,1};   %put all the indexes together
        end
        fidx = mean(idx_array,2);           %if all channels uses the same axis, then the mean is not a fraction.
        fidx = fidx==idx_array(:,1);
        fidx = find(fidx==1);   %find the ones that colocalize
        if ~isempty(fidx)   %if there are colo events
            for n = 1:size(chan,2)
                termi_tmp = all_data(n).termi{m,1};   %grab one of the termi sets to generated final set index
                curr_idx = [];  %initiate
                for o = size(fidx,1)
                    curr_idx_tmp = find(termi_tmp(:,1)==fidx(o));
                    curr_idx = vertcat(curr_idx,curr_idx_tmp);
                end
                if size(curr_idx,1)==size(termi_tmp,1)  %no change, move on.
                    all_data(n).termi{m,1} = all_data(n).termi{m,1}(:,2:end);   %remove the ordinal
                else    %take out the unwanted
                    %ok now we have the info we need lets finalize the data
                    %structure.
                    all_data(n).vert{m,1} = all_data(n).vert{m,1}(curr_idx,:);     %remove the non-events
                    all_data(n).oprop{m,1} = all_data(n).oprop{m,1}(curr_idx,:);
                    all_data(n).termi{m,1} = all_data(n).termi{m,1}(curr_idx,2:end);    %remove the ordinal
                    all_data(n).tprop{m,1} = all_data(n).tprop{m,1}(curr_idx,:);
                    all_data(n).third{m,1} = all_data(n).third{m,1}(curr_idx,:);
                    all_data(n).thirdprop{m,1} = all_data(n).thirdprop{m,1}(curr_idx,:);
                end
            end
        else  %the point is now removed.
            allidx = vertcat(allidx,m);   %add to the list of non-colo events
        end
    end
    for n = 1:size(chan,2)
        all_data(n).vert(allidx,:) = [];     %remove the non-events
        all_data(n).oprop(allidx,:) = [];
        all_data(n).termi(allidx,:) = [];
        all_data(n).tprop(allidx,:) = [];
        all_data(n).third(allidx,:) = [];
        all_data(n).thirdprop(allidx,:) = [];
    end
    close(h2);   %close progress bar
    aord_idx = aord_idx(allidx,:);
    allidx = unique(vertcat(idx,aord_idx));  %finalize
else
    nidx = idx;
    allidx = idx;
    %store the nearest data
    for l = 1:size(chan,2)
        ndata(l).vert(nidx,:) = [];     %wittle down to the final
        ndata(l).oprop(nidx,:) = [];
        ndata(l).termi(nidx,:) = [];
        ndata(l).tprop(nidx,:) = [];
        ndata(l).third(nidx,:) = [];
        ndata(l).thirdprop(nidx,:) = [];
        %instead of doing this "if ~max(idx==m)" lets just remove the non
        %colo events first. for allidx processing down below
        all_data(l).vert(idx,:) = [];     %remove the non-events
        all_data(l).oprop(idx,:) = [];
        all_data(l).termi(idx,:) = [];
        all_data(l).tprop(idx,:) = [];
        all_data(l).third(idx,:) = [];
        all_data(l).thirdprop(idx,:) = [];
        all_data(l).sort_idx(idx,:) = [];
        %remove the termi ordinals
        for m = 1:size(all_data(1).vert,1)
            all_data(l).termi{m,1} = all_data(l).termi{m,1}(:,2:end);   %remove the ordinal
        end
    end
end

%now filter the using the third channel if it is activated; this only works
%on neardata, not all_data.  Fltrall filters the all data.  Also note that
%although the neardata output is suppose to mimic punc_colo_s, but it is
%not identical, as punc_colo_s does not implement fltr3.
if fltr3
    %ord_idx = linspace(1,size(ndata(l).third,1),size(ndata(l).third,1))';  %the ordinal index will be used for the final distillation of the ndata set
    ord_idx = cell2mat(ndata(1).vert);
    ord_idx = ord_idx(:,4);
    %ord_idx(nidx,:) = [];   %lets get started
    fltr3_idx = [];
    for l = 1:size(chan,2) %step through the channels
        fltr_tmp = [cell2mat(ndata(l).third) cell2mat(ndata(l).thirdprop)];  %pull out the vertices and distances
        %fltr_tmp = [fltr_tmp linspace(1,size(fltr_tmp,1),size(fltr_tmp,1))'];  %append an oridnal system
        [cache,uidx,nuidx] = unique(fltr_tmp(:,1:3),'rows','last');      %find the unique vertices, uidx = unique index, nuidx = not unique index(not really)
        [cache,uidx2,nuidx2] = unique(fltr_tmp(:,1:3),'rows','first');   
        %if we use the only the unique index from unique, the default is
        %'last' and one of the values we want will be zeroed, so what we
        %need to do is do unique twice 'last' and 'first', find the
        %intersect of them, which is the truly unique in the dataset,
        %meaning no duplications ever
        [ur_uidx] = intersect(uidx,uidx2);
        fltr_tmp(ur_uidx,end) = 0;   %for unique vertices, set their distance to 0 as a marker.
        fltr_tmp = [fltr_tmp nuidx];    %this marks each vertex for whether it is unique or not, not binary, but more ordinal like
        fltr_data(:,:,l) = fltr_tmp;    %set it aside
    end
    fltrornot = sum(fltr_data(:,end-1,:),3);    %sum the distances, if 0 do not filter
    for m = 1:size(fltr_data,1)     %step through the dataset
        if fltrornot(m,1)~=0
            for n = 1:size(chan,2)
                if fltr_data(m,end-1,n)~=0  %here is the non-uniqueness
                    x = find(fltr_data(:,end,n)==fltr_data(m,end,n));   %find all instances of the vertex
                    comp_tmp = fltr_data(x,end-1,n);    %grab only the distances
                    comp_idx = find(comp_tmp~=min(comp_tmp));   %find the longer distance
                    fltr3_idx = vertcat(fltr3_idx,x(comp_idx));   %save it for later use; these points need to be removed
                    fltr_data(x,end-1,n) = 0;   %don't have to look at the other points again
                end
            end
            fltrornot = sum(fltr_data(:,end-1,:),3);    %if the vertex no longer need to considered then here is how we note that.
        end
    end
    fltr3_idx = unique(fltr3_idx,'rows');   %only need to remove the row once
    for l = 1:size(chan,2)
        ndata(l).vert(fltr3_idx,:) = [];     %wittle down again
        ndata(l).oprop(fltr3_idx,:) = [];
        ndata(l).termi(fltr3_idx,:) = [];
        ndata(l).tprop(fltr3_idx,:) = [];
        ndata(l).third(fltr3_idx,:) = [];
        ndata(l).thirdprop(fltr3_idx,:) = [];
    end
    ord_idx = ord_idx(fltr3_idx,:);  %grab the vertices that are removed from the set.
    %Note: if you want an index for positive selectiob just use ord_idx(fltr3_idx,:) = [].
    
    %so one must consider here that the fltr3 option is somewhat incomplete
    %as it might be adventageous to consider the interaction of nonunique
    %vertices across all possible channels of nonuniqueness, so that the
    %the vertex fate in one channel should affect the mainteance of other
    %hypothetical nonunique points in other channels.  Using this
    %information would be more accurate, but I am not doing it here,
    %because 1) it is actually quite complex to write and I think the cost
    %to benefit is not in favor of it. 2) related to the first point, the
    %occurance of one point being nonunique in multiple channels is rare.
    %3) This is a major point, which is the measure by which we use to
    %measure or calculate the more uniqueness (or which vertex is more
    %likely the real colo event) is itself arbitrary, because we would be
    %using the distance as the supposition that the closer of the two colo
    %events is the real colo event, which is probably true, but not
    %definitely true, and this uncertainty compounds the issue to the point
    %of non-action.  Note: the all case covers the upper bound and all
    %reduduncy anyway.
    nidx = unique(vertcat(nidx,ord_idx));   %this is the master index when considering nearest point
end

%now filter all dataset if it is activated.  Note: current version of this
%all filter is in beta, meaning this is a decent version of it, but a full
%upgrade is coming in the future that will occure with a full rewrite of
%colo_all, which will introduce much more control and accuracy and
%filtering options, plus an upgrade to the data in the data structure,
%which should make filter all even more accurate.  See notebook.

if fltrall
    for n = 1:size(chan,2)  %we'll work on this on a channel by channel basis
        fltrall_idx = [];       %initiate
        rmvcell_idx = [];       %initiate the remove cell index, this if for removing the cell from the original dataset
        %create the sorting matrix: ordinal(from vert),thrid vertices,
        %third distance
        tmp = cell2mat(all_data(n).vert);  %grab the ori vertices and ordinals
        tmp2 = cell2mat(all_data(n).third);     %the third point vertices
        tmp3 = cell2mat(all_data(n).thirdprop);     %we will want the distance of the third from ori
        ord_idx = unique(tmp(:,4));     %grab the ord index, so we know the correspondence of the ordinal and the cell location.
        %put them together
        sort_mat = [tmp(:,4) tmp2 tmp3(:,size(tmp3,2))];
        [cache,sort_idx] = sortrows(sort_mat(:,2:4));     %sort the vertices
        sort_mat = sort_mat(sort_idx,:);        %use the sort index to sort the actual sorting matrix
        curr_vert = sort_mat(1,:);    %initiate using the first vertex
        sort_tmp = curr_vert;   %initate the local sorting matrix
        for o = 2:size(sort_mat,1)  %step through the nonunique ones and parse the data
            vert_tmp = sort_mat(o,:);  %grab the current point
            if curr_vert(1,2:4)==vert_tmp(1,2:4)  %still in the same block of same verts
                sort_tmp = vertcat(sort_tmp,vert_tmp);  %add point to local sorting matrix.
            else    %new point
                curr_vert = vert_tmp;   %assign the point to the comparision vertices
                %now parse the local sorting matrix (this is where the
                %action is)
                if size(sort_tmp,1)~=1      %if there is only one member, aka this point is unique skip the checking.
                    uq_tmp = [];    %initiate the matrix of unique third points
                    nuq_tmp = [];   %matrix of not unique third points
                    for p = 1:size(sort_tmp,1)  %go through the local sorting matrix
                        curr_loc = find(ord_idx==sort_tmp(p,1));
                        if size(all_data(n).third{curr_loc,1},1)>1  %this third point is not unique in its ori set
                            nuq_tmp = vertcat(nuq_tmp,sort_tmp(p,:));   %vertex not unique
                        else    %vertex unique
                            uq_tmp = vertcat(uq_tmp,sort_tmp(p,:));
                        end
                    end
                    if isempty(uq_tmp)  %there are no unique vertices
                        nuq_tmp = sortrows(nuq_tmp,5);      %sort it based on distance
                        for q = 2:size(nuq_tmp,1)      %step through and expunge the records, the top is chosen, if 2 the same distance, well we discussed this earlier...
                            curr_loc = find(ord_idx==nuq_tmp(q,1));
                            [rmv_idx] = rmv_vert(nuq_tmp(q,2:4),all_data(n).third{curr_loc,1});   %get the index of removal
                            %now remove the vert
                            all_data(n).vert{curr_loc,1}(rmv_idx,:) = [];
                            all_data(n).oprop{curr_loc,1}(rmv_idx,:) = [];
                            all_data(n).termi{curr_loc,1}(rmv_idx,:) = [];
                            all_data(n).tprop{curr_loc,1}(rmv_idx,:) = [];
                            all_data(n).third{curr_loc,1}(rmv_idx,:) = [];
                            all_data(n).thirdprop{curr_loc,1}(rmv_idx,:) = [];
                            %now check if this point is not empty, if it is, we
                            %will have to remove it completely from the set
                            if isempty(all_data(n).vert{curr_loc,1})
                                rmvcell_idx = vertcat(rmvcell_idx,nuq_tmp(q,1));
                                fltrall_idx = vertcat(fltrall_idx,curr_loc);
                            end
                        end
                    else    %there is unique
                        uq_tmp = sortrows(uq_tmp,5);      %sort it based on distance
                        uq_tmp = vertcat(uq_tmp,nuq_tmp);   %put the non unique back to be removed
                        for q = 2:size(uq_tmp,1)      %step through and expunge the records, the top is chosen, if 2 the same distance, well we discussed this earlier...
                            curr_loc = find(ord_idx==uq_tmp(q,1));
                            [rmv_idx] = rmv_vert(uq_tmp(q,2:4),all_data(n).third{curr_loc,1});   %get the index of removal
                            %now remove the vert
                            all_data(n).vert{curr_loc,1}(rmv_idx,:) = [];
                            all_data(n).oprop{curr_loc,1}(rmv_idx,:) = [];
                            all_data(n).termi{curr_loc,1}(rmv_idx,:) = [];
                            all_data(n).tprop{curr_loc,1}(rmv_idx,:) = [];
                            all_data(n).third{curr_loc,1}(rmv_idx,:) = [];
                            all_data(n).thirdprop{curr_loc,1}(rmv_idx,:) = [];
                            %now check if this point is not empty, if it is, we
                            %will have to remove it completely from the set
                            if isempty(all_data(n).vert{curr_loc,1})
                                rmvcell_idx = vertcat(rmvcell_idx,uq_tmp(q,1));
                                fltrall_idx = vertcat(fltrall_idx,curr_loc);
                            end
                        end
                    end
                end
                sort_tmp = curr_vert;   %reinitate the local sorting matrix
            end
        end
        %remove the verts that were eliminated from the last cycle
        for r = 1:size(chan,2)
            all_data(r).vert(fltrall_idx,:) = [];
            all_data(r).oprop(fltrall_idx,:) = [];
            all_data(r).termi(fltrall_idx,:) = [];
            all_data(r).tprop(fltrall_idx,:) = [];
            all_data(r).third(fltrall_idx,:) = [];
            all_data(r).thirdprop(fltrall_idx,:) = [];
            all_data(r).sort_idx(fltrall_idx,:) = [];
        end
        %reconfigure the all index to remove the points removed here as
        %well.
        allidx = unique(vertcat(allidx,rmvcell_idx));
        %now make sure we are at full parsimony
        thrd_tmp = all_data(n).thirdprop;   %pull data for the third channel one more time
        for s = 1:size(thrd_tmp,1)  %step through the vertices
            if size(thrd_tmp{s,1},1)>1  %there are still more than 1 point
                %condense
                curr_tmp = thrd_tmp{s,1};   %pull the set
                [curr_tmp,curr_idx] = sortrows(curr_tmp,size(curr_tmp,2));     %sort based on distance
                %we just want the first/closest
                all_data(n).vert{s,1}(curr_idx(2:end),:) = [];
                all_data(n).oprop{s,1}(curr_idx(2:end),:) = [];
                all_data(n).termi{s,1}(curr_idx(2:end),:) = [];
                all_data(n).tprop{s,1}(curr_idx(2:end),:) = [];
                all_data(n).third{s,1}(curr_idx(2:end),:) = [];
                all_data(n).thirdprop{s,1}(curr_idx(2:end),:) = [];
            end
        end
    end
end

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [mod,mod_fltr,termi,pp_fltr,prepost,fltr3,fltrall,visual,multi] = parse(input,chan)

mod = 0;  %Default Initialized.
mod_fltr = 0;
termi = chan(1,1);    %base scale of a unit in the x axis
pp_fltr = 0;        %off by default.
prepost = [];      %logically no.
fltr3 = 1;      %filter the third channel for uniqueness, default is on
visual = 0;
multi = 1;  %default

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'mod'
                    mod = input{1,i+1};
                case 'mod_fltr'
                    mod_fltr = input{1,i+1};
                case 'termi'
                    termi = input{1,i+1};
                case 'pp_fltr'
                    pp_fltr = input{1,i+1};
                case 'prepost'
                    prepost = input{1,i+1};
                case 'fltr3'
                    fltr3 = input{1,i+1};
                case 'visual'
                    visual = input{1,i+1};
                case 'multi'
                    multi = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        end
    end
end
%lets parse the pre post filtering a little more
if pp_fltr
    if isreal(prepost)&&isempty(prepost)         %filter is on, but prepost left blank
        prepost = zeros(size(chan));  %everything channel is considered near ori
    end
end
%check fltr3 if filter all is activated
if fltr3==2    %filter all activate
    fltrall = 1;    %on
    fltr3 = 1;  %back to something meaningful
else    %go about as usual
    fltrall = 0;    %off
end
%if visual is on then multi must be off
if visual
    if multi
        multi = 0;
    end
end

%--------------------------------------------------------------------------
%subfunction remove a set of points and return the index of removal
function [idx] = rmv_vert(vert,vert_set)

[y,x] = find(vert_set==repmat(vert,size(vert_set,1),1));  %find in the vertices set where that vertices is

idx = unique(y);    %the row location of that vertex.
%--------------------------------------------------------------------------
%Little function to allow the visual check of the data
function [] = vcheck(pp_ori,pp_termi,pp_comp,ypp,prepost,colodistmod)
scatter(0,0);   %plot the origin
hold;    %hold it
fverts = unique(flat_verts(pp_termi-pp_ori),'rows');   %translate termi
fverts2 = unique(flat_verts(pp_comp-pp_ori),'rows');   %translate third
%plot them
scatter(fverts(1,1),fverts(1,2));
scatter(fverts2(:,1),fverts2(:,2));
%label all of the third points
labelthird = num2str((1:size(fverts2,1))','%d');    %'
text(double(fverts2(:,1)),double(fverts2(:,2)),labelthird,'horizontal','left','vertical','bottom')
%calculate the distances
o_third = dddist(pp_ori,pp_comp);  %ori to third
t_third = dddist(pp_termi,pp_comp);  %termi to third
%colocalization sphere distance
colodist = dddist(pp_ori,pp_termi);
circ(0,0,colodistmod);     %plot the colo sphere
%modifications
switch prepost
    case 0      %closer to ori
        omod = nan(size(o_third));
        tmod = t_third;
    case 1i      %closer to termi
        omod = o_third;
        tmod = nan(size(t_third));
    case 100i     %ignostic
        omod = nan(size(o_third));
        tmod = nan(size(t_third));
    otherwise       %modify by prepost number
        if prepost<=0       %closer to ori
            omod = nan(size(o_third));
            tmod = t_third/prepost;
        else                    %closer to termi
            tmod = nan(size(t_third));
            omod = o_third/prepost;
        end
end
output = [(1:size(ypp,1))',o_third,omod,t_third,tmod,ypp,colodist,repmat(colodistmod,size(ypp,1),1)];
labels = {'label','ori-third','ot-mod','termi-third','tt-mod','reject','colodist','cd-mod'};
output = dataset({output,labels{:}});
display(output);
%--------------------------------------------------------------------------
function circ(x,y,r)
%x and y are the coordinates of the center of the circle
%r is the radius of the circle
%0.01 is the angle step, bigger values will draw the circle faster but
%you might notice imperfections (not very smooth)
ang=0:0.01:2*pi; 
xp=r*cos(ang);
yp=r*sin(ang);
plot(x+xp,y+yp);